package com.xforceplus.domain.account;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

/**
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class DidiAccountDataDto {
    /**
     * 客户在商户的id
     */
    @Schema(description = "客户在商户的id")
    protected String thirdUserId;
    /**
     * 1授权/修改授权 2解除授权
     */
    @Schema(description = "1授权/修改授权 2解除授权")
    protected int operate;
    /**
     * 更新授权时间 毫秒时间戳
     */
    @Schema(description = "新授权时间 毫秒时间戳")
    protected String updateTime;
}
