package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/3 20:48
 * 功能描述:
 * 修改历史:
 */
@FieldNameConstants
@Getter
@Setter
public class LoginLogDto {

    /**
     * id
     */
    @Schema(description = "id")
    protected Long id;

    /**
     * 租户Id
     */
    @Schema(description = "租户Id")
    protected Long tenantId;

    /**
     * 账号Id
     */
    @Schema(description = "账号Id")
    protected Long accountId;

    /**
     * 用户id
     */
    @Schema(description = "用户id")
    protected Long userId;

    /**
     * 登录账号
     */
    @Schema(description = "登录账号")
    protected String loginName;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date loginTime;

}
