package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 微信信息表
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class WechatInfoDto {
    /**
     * id
     */
    protected Long id;

    /**
     * access_token
     */
    protected String accessToken;

    /**
     * token生成时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date tokenTime;

    /**
     * token有效期
     */
    protected Integer tokenPeriod;

    /**
     * jsapi_ticket
     */
    protected String jsapiTicket;

    /**
     * ticket生成时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date ticketTime;

    /**
     * ticket有效期
     */
    protected Integer ticketPeriod;

    /**
     * 状态 1:启用, 0:禁用
     */
    protected Integer status;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    protected Date createTime;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    protected Date updateTime;

}
