package com.xforceplus.domain.cloudshell;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 创建任务请求报文
 *
 * @author geewit
 */
@Schema(name = "创建任务请求报文")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class CreateTaskRequest {
    /**
     * 任务备注
     */
    @Schema(description = "任务备注")
    private String description;
    /**
     * 基准环境租户代码
     */
    @NotBlank(message = "基准环境租户代码不能为空")
    @Schema(description = "基准环境租户代码")
    private String sourceTenantCode;
    /**
     * 基准环境租户名称
     */
    @NotBlank(message = "基准环境租户名称不能为空")
    @Schema(description = "基准环境租户名称")
    private String sourceTenantName;
    /**
     * 目标环境租户代码
     */
    @NotBlank(message = "目标环境租户代码不能为空")
    @Schema(description = "目标环境租户代码")
    private String targetTenantCode;
    /**
     * 目标环境租户名称
     */
    @NotBlank(message = "目标环境租户名称不能为空")
    @Schema(description = "目标环境租户名称")
    private String targetTenantName;
}