package com.xforceplus.domain.cloudshell;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.Objects;
import java.util.StringJoiner;

/**
 * 预检租户目标信息.
 *
 * @author dongbin
 * @version 0.1 2023/6/9 16:30
 * @since 1.8
 */
@Schema(name = "预检租户目标信息")
public class PrecheckTenant {

    /**
     * 租户编码.
     */
    @Schema(description = "租户编码")
    private final String tenantCode;

    /**
     * 租户名称.
     */
    @Schema(description = "租户名称")
    private final String tenantName;

    public PrecheckTenant(String tenantCode, String tenantName) {
        this.tenantCode = tenantCode;
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public String getTenantName() {
        return tenantName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrecheckTenant)) {
            return false;
        }
        PrecheckTenant that = (PrecheckTenant) o;
        return Objects.equals(getTenantCode(), that.getTenantCode()) &&
            Objects.equals(getTenantName(), that.getTenantName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTenantCode(), getTenantName());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PrecheckTenant.class.getSimpleName() + "[", "]")
            .add("tenantCode='" + tenantCode + "'")
            .add("tenantName='" + tenantName + "'")
            .toString();
    }


}
