package com.xforceplus.domain.cloudshell;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.Objects;
import java.util.StringJoiner;

/**
 * 预检环境是否匹配.
 *
 * @author dongbin
 * @version 0.1 2023/6/9 16:32
 * @since 1.8
 */
@Schema(name = "预检环境是否匹配")
public class PrecheckTenantContrast extends PrecheckTenant {

    @Schema(description = "租户名称是否匹配")
    private final boolean nameMatch;

    @Schema(description = "租户编码是否匹配")
    private final boolean codeMatch;

    public PrecheckTenantContrast(String tenantCode, String tenantName, boolean nameMatch, boolean codeMatch) {
        super(tenantCode, tenantName);

        this.nameMatch = nameMatch;
        this.codeMatch = codeMatch;
    }

    public boolean isNameMatch() {
        return nameMatch;
    }

    public boolean isCodeMatch() {
        return codeMatch;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrecheckTenantContrast)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrecheckTenantContrast that = (PrecheckTenantContrast) o;
        return this.isNameMatch() == that.isNameMatch() && this.isCodeMatch() == that.isCodeMatch();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isNameMatch(), this.isCodeMatch());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PrecheckTenantContrast.class.getSimpleName() + "[", "]")
            .add("tenantCode='" + getTenantCode())
            .add("tenantName='" + getTenantName())
            .add("codeMatch=" + codeMatch)
            .add("nameMatch=" + nameMatch)
            .toString();
    }


}
