package com.xforceplus.domain.cloudshell;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * 预检租户结果.
 *
 * @author dongbin
 * @version 0.1 2023/6/9 16:18
 * @since 1.8
 */
@Schema(name = "预检租户结果")
public class PrecheckTenantResponse {

    /**
     * 目标端租户信息.
     */
    @Schema(description = "目标端租户信息")
    private final PrecheckTenant tenant;

    /**
     * 远程租户对比结果.
     */
    @ArraySchema(schema = @Schema(description = "远程租户对比结果", implementation = PrecheckTenantContrast.class))
    private final List<PrecheckTenantContrast> contrasts;

    public PrecheckTenantResponse(PrecheckTenant tenant, List<PrecheckTenantContrast> contrasts) {
        this.tenant = tenant;
        this.contrasts = contrasts;
    }

    public PrecheckTenant getTenant() {
        return tenant;
    }

    public List<PrecheckTenantContrast> getContrasts() {
        return contrasts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrecheckTenantResponse)) {
            return false;
        }
        PrecheckTenantResponse that = (PrecheckTenantResponse) o;
        return Objects.equals(getTenant(), that.getTenant()) &&
            Objects.equals(getContrasts(), that.getContrasts());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTenant(), getContrasts());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PrecheckTenantResponse.class.getSimpleName() + "[", "]")
            .add("contrasts=" + contrasts)
            .add("tenant=" + tenant)
            .toString();
    }
}
