package com.xforceplus.domain.cloudshell;

import com.xforceplus.enums.cloudshell.TaskStatus;
import java.util.Date;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 任务详情响应报文
 *
 * @author geewit
 */
@Schema(name = "任务详情响应报文")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class TaskInfoResponse {
    /**
     * 任务备注
     */
    @Schema(description = "任务备注")
    private String description;
    /**
     * 基准环境租户代码
     */
    @Schema(description = "基准环境租户代码")
    private String sourceTenantCode;
    /**
     * 基准环境租户名称
     */
    @Schema(description = "基准环境租户名称")
    private String sourceTenantName;
    /**
     * 目标环境租户代码
     */
    @Schema(description = "目标环境租户代码")
    private String targetTenantCode;
    /**
     * 目标环境租户名称
     */
    @Schema(description = "目标环境租户名称")
    private String targetTenantName;
    /**
     * 任务状态
     */
    @Schema(description = "任务状态")
    private TaskStatus status;
    /**
     * 创建人id
     */
    @Schema(description = "创建人id")
    private String createrId;
    /**
     * 创建人名称
     */
    @Schema(description = "创建人名称")
    private String createrName;
    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private Date createTime;
}