package com.xforceplus.domain.cloudshell;

import com.xforceplus.enums.cloudshell.TaskStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 任务列表查询请求
 *
 * @author geewit
 */
@Schema(name = "任务列表查询请求")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class TaskListRequest {
    /**
     * 任务编号
     */
    @Schema(description = "任务编号")
    private Long taskId;
    /**
     * 目标环境租户代码
     */
    @Schema(description = "目标环境租户代码")
    private String targetTenantCode;
    /**
     * 目标环境租户名称
     */
    @Schema(description = "目标环境租户名称")
    private String targetTenantName;
    /**
     * 任务状态
     */
    @Schema(description = "任务状态")
    private TaskStatus status;
}