package com.xforceplus.domain.cloudshell;

import com.xforceplus.enums.cloudshell.TaskOperationTarget;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 任务列表查询请求
 *
 * @author Adnis
 */
@Schema(name = "任务操作结果异常列表查询请求")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class TaskOperationRequest {
    /**
     * 任务编号
     */
    @NotNull
    @Schema(description = "任务编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private Long taskId;
    /**
     * 操作目标列表
     */
    @NotNull
    @Schema(description = "操作目标列表",
        allowableValues = {"ACCOUNT", "COMPANY", "ORGANIZATION", "RESOURCE_SET", "RESOURCE_CODE", "ROLE",
            "CUSTOMIZATION_SERVICE_PACKAGE", "USER"},
        requiredMode = Schema.RequiredMode.REQUIRED)
    private List<TaskOperationTarget> targetList;
}