package com.xforceplus.domain.cloudshell;

import com.xforceplus.enums.cloudshell.TaskOperationFailureCause;
import com.xforceplus.enums.cloudshell.TaskOperationRunStatus;
import com.xforceplus.enums.cloudshell.TaskOperationTarget;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * 任务操作结果异常列表查询结果
 *
 * @author Adnis
 */
@Schema(name = "任务操作结果异常列表查询结果")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
@ToString
public class TaskOperationResponse {
    /**
     * 任务编号
     */
    @Schema(description = "任务编号")
    private Long taskId;
    /**
     * 操作编号
     */
    @Schema(description = "操作编号")
    private Long operationId;
    /**
     * 对象名称
     */
    @Schema(description = "对象名称")
    private String name;
    /**
     * 代码
     */
    @Schema(description = "代码")
    private String code;
    /**
     * 对象类型
     */
    @Schema(description = "对象类型。'ACCOUNT ｜ COMPANY ｜ ORGANIZATION ｜ RESOURCE_SET ｜ RESOURCE_CODE ｜ ROLE ｜ " +
        "CUSTOMIZATION_SERVICE_PACKAGE ｜ USER'")
    private TaskOperationTarget target;
    /**
     * 同步结果
     */
    @Schema(description = "同步结果。'SUCCESS | FAILURE'}")
    private TaskOperationRunStatus status;
    /**
     * 异常原因
     */
    @Schema(description = "异常原因。'DUPLICATE(重复) | DATA_INVALID(无效数据)'")
    private TaskOperationFailureCause cause;
}