package com.xforceplus.domain.cloudshell;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.enums.cloudshell.TaskStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 任务列表响应
 *
 * @author geewit
 */
@Schema(name = "任务列表响应")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class TaskResponse {
    /**
     * 任务编号
     */
    @Schema(description = "任务编号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long taskId;
    /**
     * 任务备注
     */
    @Schema(description = "任务备注")
    private String description;
    /**
     * 目标环境租户代码
     */
    @Schema(description = "目标环境租户代码")
    private String targetTenantCode;
    /**
     * 目标环境租户名称
     */
    @Schema(description = "目标环境租户名称")
    private String targetTenantName;
    /**
     * 目标环境租户代码
     */
    @Schema(description = "基准环境租户代码")
    private String sourceTenantCode;
    /**
     * 目标环境租户名称
     */
    @Schema(description = "基准环境租户名称")
    private String sourceTenantName;
    /**
     * 任务状态
     */
    @Schema(description = "任务状态")
    private TaskStatus status;
    /**
     * 创建人名称
     */
    @Schema(description = "创建人名称")
    private String createrName;
    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    private LocalDateTime createTime;
    /**
     * 完成时间
     */
    @Schema(description = "完成时间")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long finishTime;
}