package com.xforceplus.domain.cloudshell;

import com.xforceplus.enums.cloudshell.extra.UserAccountTemporaryStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import javax.validation.constraints.NotNull;

/**
 * 用户账号查询列表请求报文
 *
 * @author adnis
 */
@Schema(name = "用户账号查询列表请求报文")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
@ToString
public class UserAccountExtraRequest {

    @NotNull
    @Schema(description = "方案ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private Long schemeId;

    @Schema(description = "用户帐号状态。", allowableValues = {"EXCLUSION", "INCLUSION", "CONFLICT"})
    private UserAccountTemporaryStatus status;

    @Schema(description = "关键词")
    private String keyword;
}