package com.xforceplus.domain.cloudshell;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.enums.cloudshell.extra.UserAccountTemporaryStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

/**
 * 用户账号列表响应
 *
 * @author adnis
 */
@Schema(name = "用户账号列表响应")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Setter
@Getter
public class UserAccountResponse {

    @Schema(description = "extra编号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @Schema(description = "user-人员名")
    private String remoteUserName;

    @Schema(description = "account-手机号码")
    private String remoteAccountPhone;

    @Schema(description = "account-邮箱地址")
    private String remoteAccountEmail;

    @Schema(description = "account-账号名")
    private String remoteAccountName;

    @Schema(description = "状态")
    private UserAccountTemporaryStatus status;
}