package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.json.ExtensionView;
import com.xforceplus.tenant.security.core.domain.ICompany;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 公司
 * @author geewit
 */
@SuppressWarnings("all")
@FieldNameConstants
@Setter
@Getter
public class CompanyDto<O extends OrgDto<O>> implements ICompany, IOperator {
    /**
     * 公司id
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected Long companyId;

    /**
     * 企业编码
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected String companyCode;

    /**
     * 企业名称
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected String companyName;

    /**
     * 税号
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected String taxNum;

    /**
     * 公司经营所在省份
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String locationArea;

    /**
     * 公司经营所在市区
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String locationCity;

    /**
     * 公司经营详细地址
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String locationAddr;

    /**
     * 公司经营电话
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String companyPhone;

    /**
     * 营业期限开始时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date businessStartTime;

    /**
     * 营业期限结束时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date businessEndTime;

    /**
     * 营业时间是否长期
     */
    @JsonView({View.Info.class, RedisView.class})
    protected Integer businessTimeLong;

    /**
     * 企业经营范围
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String businessScope;

    /**
     * 企业Logo
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String companyLogo;

    /**
     * 营业执照影像
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String businessLicense;

    /**
     * 平台管理人身份  0:法定代表人, 1:代理人
     */
    @JsonView({View.Info.class, RedisView.class})
    protected Integer platManagerStatus;

    /**
     * 法人归属地
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerLocation;

    /**
     * 法人姓名
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerName;

    /**
     * 法人证件类型  1-身份证
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerCardType;

    /**
     * 法人身份证
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerIdCard;

    /**
     * 法人联系方式
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerPhone;

    /**
     * 法人证件开始时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date managerIdCardStartTime;

    /**
     * 法人证件结束时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date managerIdCardEndTime;

    /**
     * 法人身份证长期
     */
    @JsonView({View.Info.class, RedisView.class})
    protected Integer managerIdCardTimeLong;

    /**
     * 法人证件正面照
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerIdCardFrontPhoto;

    /**
     * 法人证件背面照
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String managerIdCardBackPhoto;

    /**
     * 开户行名称
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String bankName;

    /**
     * 开户银行支行名称
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String bankBranchName;

    /**
     * 对公银行账户
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String bankNo;

    /**
     * 银行所在省份
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String bankArea;

    /**
     * 银行所在市区
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String bankCity;

    /**
     * 注销/启用原因
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String operateReason;

    /**
     * 传统认证管理状态  1:开启；0:关闭
     */
    @JsonView({View.class, RedisView.class})
    protected Integer traditionAuthenFlag;

    /**
     * 查验服务状态  1:开启；0:关闭
     */
    @JsonView({View.class, RedisView.class})
    protected Integer inspectionServiceFlag;

    /**
     * 极速查验通道状态  1:开启；0:关闭
     */
    @JsonView({View.class, RedisView.class})
    protected Integer speedInspectionChannelFlag;

    /**
     * 启用状态  1:审核中, 2:审核不通过, 3:审核通过
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected Integer status;

    /**
     * 增值税普通发票限额
     */
    @JsonView({View.List.class, View.Page.class, RedisView.class})
    protected BigDecimal cquota;

    /**
     * 增值税专用发票限额
     */
    @JsonView({View.Info.class, RedisView.class})
    protected BigDecimal squota;

    /**
     * 增值税电子普通发票限额
     */
    @JsonView({View.Info.class, RedisView.class})
    protected BigDecimal ceQuota;

    /**
     * 增值税普通发票-卷票限额
     */
    @JsonView({View.Info.class, RedisView.class})
    protected BigDecimal juQuota;

    /**
     * 增值税电子专票限额
     */
    @JsonView({View.Info.class, RedisView.class})
    protected BigDecimal seQuota;

    /**
     * 机动车发票限额
     */
    @JsonView({View.Info.class, RedisView.class})
    protected BigDecimal vehicleLimit;

    /**
     * 企业注册省份
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String registLocationArea;

    /**
     * 企业注册城市
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String registLocationCity;

    /**
     * 企业注册详细地址
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String registLocationAddr;

    /**
     * 纳税人资质类型 1:一般纳税人 2:小规模纳税人
     */
    @JsonView({View.class, RedisView.class})
    protected Integer taxpayerQualificationType;

    /**
     * 纳税人资质证书
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String taxpayerQualification;

    /**
     * 代理人姓名
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerName;

    /**
     * 代理人证据类型  1-身份证
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerCardType;

    /**
     * 代理人身份证
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerIdCard;

    /**
     * 代理人联系方式
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerPhone;

    /**
     * 代理人证件开始时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date proxyManagerIdCardStartTime;

    /**
     * 代理人证件结束时间
     */
    @JsonView({View.Info.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date proxyManagerIdCardEndTime;

    /**
     * 代理人身份证长期
     */
    @JsonView({View.Info.class, RedisView.class})
    protected Integer proxyManagerIdCardTimeLong;

    /**
     * 代理人证件正面照
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerIdCardFrontPhoto;

    /**
     * 代理人证件背面照
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String proxyManagerIdCardBackPhoto;

    /**
     * 认证方式
     */
    @JsonView({View.Info.class, RedisView.class})
    protected String identificationType;

    /**
     * 创建时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    @JsonView({View.class, RedisView.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({View.class, RedisView.class})
    protected String createrName;

    /**
     * 更新人id
     */
    @JsonView({View.class, RedisView.class})
    protected String updaterId;

    /**
     * 更新人名称
     */
    @JsonView({View.class, RedisView.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 生效时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date effectiveDate;

    /**
     * 是否生效
     */
    @JsonView({View.class, RedisView.class})
    protected Boolean effective;

    @JsonView({View.Page.class, ExtensionView.Extension.class})
    protected List<CompanyExtensionDto> extensions;

    /**
     * 关联租户集合
     */
    @JsonView({View.List.class, View.Page.class, View.Info.class})
    protected Set<Relation<O>> relations;

    @JsonView({View.List.class, View.Page.class})
    protected Long tenantId;
    /**
     * 租户名
     */
    @JsonView({View.List.class, View.Page.class})
    protected String tenantName;
    /**
     * 租户代码
     */
    @JsonView({View.List.class, View.Page.class})
    protected String tenantCode;

    /**
     * 主租户id
     */
    @JsonView({View.List.class, View.Page.class})
    protected Long hostTenantId;

    /**
     * 主租户名
     */
    @JsonView({View.List.class, View.Page.class})
    protected String hostTenantName;
    /**
     * 主租户代码
     */
    @JsonView({View.List.class, View.Page.class})
    protected String hostTenantCode;

    /**
     * 所在主租户组织
     */
    @JsonView({View.Info.class})
    protected List<O> hostOrgs;

    @JsonView({View.List.class, View.Page.class})
    public String getHostTenantName() {
        return this.hostTenantName;
    }

    @JsonView({View.List.class, View.Page.class})
    public String getHostTenantCode() {
        return this.hostTenantCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompanyDto) {
            CompanyDto that = (CompanyDto) o;
            return Objects.equals(this.companyId, that.companyId);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.companyId);
    }
}
