/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyHisDTO.java   2021-03-08 10-37-16
 * Author: Evan
 */
package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-03-08 10-37-16
 * @since V1.0
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class CompanyHisDTO implements Serializable {
    /**
     * 公司税号
     */
    @JsonView({View.Info.class})
    protected String taxNum;
    /**
     * 启用状态  1:启用, 0:注销
     */
    @JsonView({View.List.class, View.Page.class})
    protected Integer status;
    /**
     * 生效时间
     */
    @JsonView({View.Info.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date effectiveDate;
    /**
     * 公司ID
     */
    @JsonView({View.Info.class})
    private Long companyId;
    /**
     * 企业编码
     */
    @JsonView({View.Info.class})
    private String companyCode;
    /**
     * 公司名称
     */
    @JsonView({View.Info.class})
    private String companyName;
    /**
     * 历史记录是否有效
     */
    @JsonView({View.Info.class})
    private Byte effective;
    /**
     * 更新时间
     */
    @JsonView({View.Info.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    public Boolean getEffective() {
        return 1 == this.effective;
    }
}
