package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 公司服务包
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class CompanyPackage {
    protected Long id;
    /**
     * 租户id
     */
    protected Long tenantId;
    /**
     * 租户代码
     */
    protected String tenantCode;
    /**
     * 租户名称
     */
    protected String tenantName;
    /**
     * 公司id
     */
    protected Long companyId;
    /**
     * 公司名称
     */
    protected String companyName;
    /**
     * 服务包名称
     */
    protected String servicePackageName;
    /**
     * 启用状态  1:启用, 0:注销
     */
    protected Integer status;
    /**
     * 税号
     */
    protected String taxNum;
    /**
     * 创建人
     */
    protected String createUserName;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date createTime;
    /**
     * 服务包名称集合
     */
    protected List<String> packageNames;
    /**
     * 服务包Id集合
     */
    protected List<Long> packageIds;

    public CompanyPackage() {
    }

    public CompanyPackage(String servicePackageName, String companyName, Integer status) {
        this.servicePackageName = servicePackageName;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long tenantId, String tenantName, Long companyId, String companyName, Integer status) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long id, Long tenantId, String tenantCode, String tenantName, Long companyId, String companyName, String taxNum, Integer status, String createUserName, Date createTime) {
        this.id = id;
        this.tenantId = tenantId;
        this.tenantCode = tenantCode;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.status = status;
        this.taxNum = taxNum;
        this.createUserName = createUserName;
        this.createTime = createTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyPackage that = (CompanyPackage) o;
        return Objects.equals(tenantId, that.tenantId) && Objects.equals(companyId, that.companyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, companyId);
    }
}
