package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.geewit.core.utils.enums.EnumMapUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class CompanyTenantRelDto implements Serializable {
    protected Long id;
    /**
     * 所属租户主体公司id
     */
    protected Long invitingCompanyId;
    /**
     * 所属租户主体公司名称
     */
    protected String invitingCompanyName;
    /**
     * 企业id
     */
    protected Long companyId;
    /**
     * 企业名称
     */
    protected String companyName;
    /**
     * 公司编码
     */
    protected String companyCode;
    /**
     * 税号
     */
    protected String taxNum;
    /**
     * 租户id
     */
    protected Long tenantId;
    /**
     * 租户名称
     */
    protected String tenantName;
    /**
     * 租户代码
     */
    protected String tenantCode;
    /**
     * 所属租户id
     */
    protected Long hostTenantId;
    /**
     * 所属租户名称
     */
    protected String hostTenantName;
    /**
     * 所属租户代码
     */
    protected String hostTenantCode;
    /**
     * 被关联租户id
     */
    protected Long relatedTenantId;
    /**
     * 被关联租户名称
     */
    protected String relatedTenantName;
    /**
     * 被关联租户代码
     */
    protected String relatedTenantCode;
    /**
     * 被关联公司id
     */
    protected Long relatedCompanyId;
    /**
     * 被关联公司税号
     */
    protected String relatedTaxNum;
    /**
     * 被关联公司名称
     */
    protected String relatedCompanyName;
    /**
     * 被关联公司编码
     */
    protected String relatedCompanyCode;
    /**
     * 开关组合 发票数据:1, 结算单:2, 税控终端&税控设备: 4
     */
    protected Integer switches;
    /**
     * 共享历史发票授权时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date invoiceGrantedTime;
    /**
     * 共享历史发票起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date invoiceStartDate;
    /**
     * 共享历史结算单授权时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date statementGrantedTime;
    /**
     * 共享历史结算单起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date statementStartDate;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 开关组合列表  发票数据:1, 结算单:2, 税控终端&税控设备: 4
     * @return
     */
    public List<Integer> getSwitchesList() {
        return Switch.toValues(this.switches);
    }

    /**
     * 枚举化的开关组合Map
     * @return
     */
    public Map<Switch, Boolean> getSwitchesMap() {
        return EnumMapUtils.toEnumMap(Switch.class, this.switches);
    }
}
