package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.core.utils.enums.EnumMapUtils;
import io.geewit.core.utils.enums.Value;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/***
 * 公司租户关联关系操作记录 Dto
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class CompanyTenantRelOperationDto implements ICreater {
    public static final int OPERATION_TYPE_INVITE = 0;
    public static final int OPERATION_TYPE_UNRELATE = 1;

    protected Long id;
    /**
     * 所属租户主体公司id
     */
    protected Long invitingCompanyId;
    /**
     * 所属租户主体公司名称
     */
    protected String invitingCompanyName;
    /**
     * 关联公司id
     */
    protected Long companyId;
    /**
     * 关联公司名称
     */
    protected String companyName;
    /**
     * 关联公司编码
     */
    protected String companyCode;
    /**
     * 关联公司税号
     */
    protected String taxNum;
    /**
     * 关联租户id
     */
    protected Long tenantId;
    /**
     * 关联租户名称
     */
    protected String tenantName;
    /**
     * 关联租户代码
     */
    protected String tenantCode;
    /**
     * 被关联租户id
     */
    protected Long relatedTenantId;
    /**
     * 被关联租户名称
     */
    protected String relatedTenantName;
    /**
     * 被关联租户代码
     */
    protected String relatedTenantCode;
    /**
     * 被关联公司id
     */
    protected Long relatedCompanyId;
    /**
     * 被关联公司税号
     */
    protected String relatedTaxNum;
    /**
     * 被关联公司名称
     */
    protected String relatedCompanyName;
    /**
     * 被关联公司编码
     */
    protected String relatedCompanyCode;
    /**
     * 开关组合 发票数据:1, 结算单:2, 税控终端&税控设备: 4
     */
    protected Integer switches;
    /**
     * 共享历史发票起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date invoiceStartDate;
    /**
     * 共享历史结算单起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date statementStartDate;
    /**
     * 操作类型  0:邀请关联, 1:取消关联
     */
    protected Integer operationType;
    /**
     * 审核状态  0:待确认, 1:确认, 2:拒绝, 3:取消邀请
     */
    protected Integer status;
    /**
     * 邀请备注
     */
    protected String inviteRemark;
    /**
     * 审核备注
     */
    protected String auditRemark;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    /**
     * 创建人id
     */
    protected String createrId;
    /**
     * 创建人名称
     */
    protected String createrName;
    /**
     * 创建人租户id
     */
    protected Long createrTenantId;
    /**
     * 创建人租户名称
     */
    protected String createrTenantName;
    /**
     * 审核人id
     */
    protected Long auditorId;
    /**
     * 审核人名称
     */
    protected String auditorName;
    /**
     * 审核时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date auditTime;
    /**
     * 审核人租户id
     */
    protected Long auditorTenantId;
    /**
     * 审核人租户名称
     */
    protected String auditorTenantName;
    /**
     * 所属租户id
     */
    protected Long hostTenantId;
    /**
     * 所属租户名称
     */
    protected String hostTenantName;
    /**
     * 所属租户代码
     */
    protected String hostTenantCode;

    /**
     * @return 开关组合列表  发票数据:1, 结算单:2, 税控终端&税控设备: 4
     */
    public List<Integer> getSwitchesList() {
        return Switch.toValues(this.switches);
    }

    /**
     * @return 枚举化的开关组合Map
     */
    public Map<Switch, Boolean> getSwitchesMap() {
        return EnumMapUtils.toEnumMap(Switch.class, this.switches);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompanyTenantRelOperationDto)) {
            return false;
        }
        CompanyTenantRelOperationDto that = (CompanyTenantRelOperationDto) o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public enum Status implements Value<Integer> {
        /**
         * 初始化, 待审核
         */
        INITED(0),
        /**
         * 已接受邀请
         */
        ACCEPTED(1),
        /**
         * 已拒绝邀请
         */
        REFUSED(2),
        /**
         * 已撤销邀请
         */
        CANCELED(3);

        private final int value;

        Status(int value) {
            this.value = value;
        }

        @Override
        public Integer value() {
            return value;
        }
    }
}
