package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.Objects;
import java.util.Set;

/**
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class RelatedTenant<O extends OrgDto<O>> {
    /**
     * 租户id
     */
    @JsonView({View.class})
    protected Long tenantId;

    /**
     * 租户名称
     */
    @JsonView({View.class})
    protected String tenantName;

    /**
     * 租户代码
     */
    @JsonView({View.class})
    protected String tenantCode;

    /**
     * 所在组织集合
     */
    @JsonView({View.class})
    protected Set<O> orgs;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelatedTenant)) {
            return false;
        }
        RelatedTenant<O> that = (RelatedTenant<O>) o;
        return Objects.equals(this.tenantId, that.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId);
    }
}
