package com.xforceplus.domain.company;

import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.enums.Value;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.List;

/**
 * 公司租户关联关系申请 开关枚举
 *
 * @author geewit
 */
public enum Switch implements Value<Integer> {
    /**
     * 发票数据
     */
    INVOICE,
    /**
     * 结算单
     */
    STATEMENT,
    /**
     * 税控终端&税控设备
     */
    TAX_TERMINAL_DEVICE;

    @Override
    public Integer value() {
        return BinaryUtils.toBinary(this);
    }

    public static int toValue(Collection<Integer> values) {
        if (values == null || values.isEmpty()) {
            return 0;
        }
        int allTrue = BinaryUtils.allTrue(Switch.class);
        int switches = 0;
        for (int switchValue : values) {
            switchValue &= allTrue;
            switches |= switchValue;
        }
        return switches;
    }

    public static int toValue(String value) {
        if (StringUtils.isBlank(value)) {
            return 0;
        }
        String[] splittedValues = StringUtils.split(value, ",");
        int allTrue = BinaryUtils.allTrue(Switch.class);
        int switches = 0;
        for (String splittedValue : splittedValues) {
            try {
                int switchValue = Integer.parseInt(splittedValue);
                switchValue &= allTrue;
                switches |= switchValue;
            } catch (NumberFormatException ignored) {
            }
        }
        return switches;
    }

    public static List<Integer> toValues(int value) {
        List<Integer> values = BinaryUtils.fromBinaryToValues(value, Switch.class);
        return values;
    }

    public static int allTrue() {
        return BinaryUtils.allTrue(Switch.class);
    }

}
