package com.xforceplus.domain.conf;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.BaseDto;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.List;
import java.util.stream.IntStream;

/**
 * 隐私协议版本记录
 * @author HWT
 * @since  2022/1/06 15:35
 */
@FieldNameConstants
@Setter
@Getter
public class PrivacyAgreementDto<P extends PrivacyAgreementProtocolDto> extends BaseDto {

    /**
     * id
     */
    protected Long id;

    /**
     * 整体描述内容
     */
    @JsonView(View.class)
    protected String content;

    /**
     * 状态  1：启用 0：未启用
     */
    @JsonView(View.class)
    protected Integer status;

    /**
     * 公司类型  默认 1:云励
     */
    @JsonView(View.class)
    protected Integer companyType;

    /**
     * 隐私版本号
     */
    @JsonView(View.class)
    protected String version;

    /**
     * 隐私明细
     */
    @ArraySchema(schema = @Schema(implementation = PrivacyAgreementProtocolDto.class))
    @JsonView(View.class)
    @JsonManagedReference
    protected List<P> protocols;

    public static <P extends PrivacyAgreementProtocolDto> void sortProtocols(List<P> protocols) {
        if (protocols != null && !protocols.isEmpty()) {
            protocols.sort((o1, o2) -> {
                if (o1.getOrdinal() == null) {
                    o1.setOrdinal(Integer.MAX_VALUE);
                }
                if (o2.getOrdinal() == null) {
                    o2.setOrdinal(Integer.MAX_VALUE);
                }
                return o1.getOrdinal().compareTo(o2.getOrdinal());
            });
        }
    }

    public static <P extends PrivacyAgreementProtocolDto> void arrangeProtocolsOrdinal(List<P> protocols) {
        if (protocols == null || protocols.isEmpty()) {
            return;
        }
        IntStream.range(0, protocols.size()).forEach(i -> protocols.get(i).setOrdinal(i + 1));
    }
}
