package com.xforceplus.domain.conf;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

/**
 * 隐私协议版本记录明细
 * @author HWT
 * @since  2022/1/06 15:35
 */
@Schema(name = "隐私协议版本记录明细")
@FieldNameConstants
@Setter
@Getter
public class PrivacyAgreementProtocolDto {

    /**
     * id
     */
    protected Long id;

    /**
     * 隐私协议版本记录id
     */
    protected Long agreementId;

    /**
     * 标题
     */
    @JsonView(View.class)
    protected String title;

    /**
     * 链接地址
     */
    @JsonView(View.class)
    protected String url;

    /**
     * 序号
     */
    @JsonView(View.class)
    protected Integer ordinal;
}
