package com.xforceplus.domain.conf;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.BaseDto;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

/**
 * 系统枚举值记录表
 *
 * @author HWT
 * @since 2022/1/06 15:35
 */
@FieldNameConstants
@Setter
@Getter
public class SysEnumDto extends BaseDto {

    /**
     * id
     */
    protected Long id;

    /**
     * 枚举值组的名称
     */
    @JsonView(View.class)
    protected String enumGroupName;

    /**
     * 枚举值的名称
     */
    @JsonView(View.class)
    protected String enumName;

    /**
     * 枚举值的value
     */
    @JsonView(View.class)
    protected String enumValue;

    /**
     * 枚举值value的类型
     */
    @JsonView(View.class)
    protected String enumType;

    /**
     * 枚举值的顺序
     */
    @JsonView(View.class)
    protected Integer enumSeq;
}
