package com.xforceplus.domain.greyscale;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author zombie
 */
@FieldNameConstants
@Getter
@Setter
@ToString
public class GreyscaleConfigDto implements IOperator {
    protected Long id;
    /**
     * 配置标识ID
     */
    protected Long identifierId;
    /**
     * 配置标识Code
     */
    protected String identifierCode;
    /**
     * 是否启用
     */
    protected Boolean enabled;
    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 配置标识类型，1租户，2税号，3公司
     */
    protected Integer identifierType;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;
}
