package com.xforceplus.domain.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.enums.ActionCodeEnum;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/3 20:48
 * 功能描述:
 * 修改历史:
 */
@ToString
@Setter
@Getter
public class SystemLogDTO {

    /**
     * id
     */
    protected Long id;

    /**
     * 表名
     */
    protected String tableName;

    /**
     * 批次id
     */
    protected String batchId;

    /**
     * 租户ID
     */
    protected Long tenantId;

    /**
     * 操作主键ID
     */
    protected Long identityId;

    /**
     * 操作业务类型
     */
    protected String businessType;

    /**
     * 操作类型:I U D
     */
    protected ActionCodeEnum actionCode;

    /**
     * 操作内容：json格式相关数据
     */
    protected String content;

    /**
     * 创建人ID
     */
    protected String createUserId;

    /**
     * 创建人姓名
     */
    protected String createUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    protected Date createTime;

    /**
     * 请求ID
     */
    protected String loginId;

    /**
     * 备注
     */
    protected String remark;

    public SystemLogDTO batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    public SystemLogDTO remark(String remark) {
        this.remark = remark;
        return this;
    }

    public SystemLogDTO businessType(String businessType) {
        this.businessType = businessType;
        return this;
    }
}
