package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.Objects;

/**
 * 组织扩展
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class OrgExtensionDto extends ExtensionDto {

    /**
     * 组织id
     */
    @JsonView(View.class)
    protected Long orgStructId;

    /**
     * 租户名称
     */
    @JsonView(View.List.class)
    protected String tenantName;

    /**
     * 租户id
     */
    @JsonView(View.List.class)
    protected Long tenantId;

    /**
     * 租户code
     */
    @JsonView(View.List.class)
    protected String tenantCode;

    /**
     * 组织名称
     */
    @JsonView({View.List.class})
    protected String orgName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OrgExtensionDto) {
            OrgExtensionDto that = (OrgExtensionDto) o;
            return Objects.equals(this.orgStructId, that.getOrgStructId()) && Objects.equals(super.extensionKey, that.extensionKey);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.orgStructId, super.extensionKey);
    }
}
