package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 组织类型
 * @author duanhy
 */
@FieldNameConstants
@Setter
@Getter
public class OrgTypeDto implements IOperator {

    /**
     * 组织类型ID
     */
    @JsonView(View.class)
    protected Integer orgTypeId;

    /**
     * 租户id
     */
    @JsonView(View.class)
    protected Long tenantId;

    /**
     * 类型名称
     */
    @JsonView(View.class)
    protected String name;

    /**
     * 类型code
     */
    @JsonView(View.class)
    protected String code;

    /**
     * 状态  1:启用 0:停用
     */
    @JsonView(View.class)
    protected Integer status;

    /**
     * 删除状态 true:删除 false:未删除
     */
    @JsonView(View.class)
    protected Boolean deleted;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
