package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 虚拟组织
 * @author duanhaiyuan
 */
@FieldNameConstants
@ToString
@Setter
@Getter
public class OrgVirtualDTO implements IOperator {

    /**
     * 虚拟组织id
     */
    protected Long orgVirtualId;

    /**
     * 虚拟组织id
     */
    protected Long orgStructId;

    /**
     * 租户id
     */
    protected Long tenantId;

    /**
     * 组织代码
     */
    protected String orgCode;

    /**
     * 组织名称
     */
    protected String orgName;

    /**
     * 简称
     */
    protected String shortName;

    /**
     * 组织备注
     */
    protected String orgDesc;

    /**
     * 状态：0 停用 1 启用
     */
    protected Integer status;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 组织树id
     */
    protected Long orgVirtualNodeId;
}
