package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * 虚拟组织节点
 * @author duanhaiyuan
 */
@FieldNameConstants
@ToString
@Setter
@Getter
public class OrgVirtualNodeDTO implements IOperator {

    /**
     * 主键
     */
    protected Long orgVirtualNodeId;

    /**
     * 虚拟组织ID
     */
    protected Long orgVirtualId;

    /**
     * 租户id
     */
    protected Long tenantId;

    /**
     * 上级组织id
     */
    protected Long parentId;

    /**
     * 上级组织路径
     */
    protected String parentIds;

    /**
     * 组织类型id
     */
    protected Long nodeTypeId;

    /**
     * 下级组织数量
     */
    protected Integer childrenCount;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrgVirtualNodeDTO that = (OrgVirtualNodeDTO) o;
        if (this.orgVirtualNodeId == null && that.orgVirtualNodeId == null) {
            return Objects.equals(orgVirtualId, that.orgVirtualId) && Objects.equals(tenantId, that.tenantId);
        }
        return Objects.equals(orgVirtualNodeId, that.orgVirtualNodeId);
    }

    @Override
    public int hashCode() {
        if (this.orgVirtualNodeId != null) {
            return Objects.hash(orgVirtualNodeId);
        } else {
            return Objects.hash(orgVirtualId, tenantId);
        }
    }
}
