package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author duanhaiyuan
 */
@FieldNameConstants
@ToString
@Setter
@Getter
public class OrgVirtualNodeTypeDTO {

    /**
     * 主键
     */
    protected Long id;

    /**
     * 类型code
     */
    protected String typeCode;

    /**
     * 类型名称
     */
    protected String typeName;


    /**
     * 使用范围
     */
    protected String scopeKey;

    /**
     * 适用对象
     */
    protected String scopeValue;


    /**
     * 备注
     */
    protected String typeDesc;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;


}
