package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 10:51
*/
@FieldNameConstants
@Setter
@Getter
public class OrgVirtualOrgStructDTO implements IOperator {

    /**
     * 主键
     */
    protected Long id;

    /**
     * 虚拟组织id
     */
    protected Long orgVirtualId;


    /**
     * 实体组织id
     */
    protected Long orgStructId;


    /**
     * 租户id
     */
    protected Long tenantId;


    /**
     * 行政组织名称
     */
    protected String orgStructName;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 组织树id
     */
    protected Long orgVirtualNodeId;

    @Override
    public String toString() {
        return "OrgVirtualOrgStructDTO{" +
            "id=" + id +
            ", orgVirtualId=" + orgVirtualId +
            ", orgStructId=" + orgStructId +
            ", tenantId=" + tenantId +
            ", orgStructName='" + orgStructName + '\'' +
            ", createTime=" + createTime +
            ", createrId='" + createrId + '\'' +
            ", createrName='" + createrName + '\'' +
            ", updaterId='" + updaterId + '\'' +
            ", updaterName='" + updaterName + '\'' +
            ", updateTime=" + updateTime +
            ", orgVirtualNodeId=" + orgVirtualNodeId +
            '}';
    }
}
