package com.xforceplus.domain.orgVirtual;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

import java.util.Objects;
import java.util.Set;

/**
 * reactjs tree
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/23 10:34
 * 功能描述:
 * 修改历史:
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class OrgVirtualTreeNode {
    /**
     * key
     */
    private Long key;

    /**
     * orgCode
     */
    private String orgCode;

    /**
     * orgName
     */
    private String orgName;

    /**
     * shortName
     */
    private String shortName;

    /**
     * orgDesc
     */
    private String orgDesc;

    /**
     * pid
     */
    @JsonIgnore
    private Long pid;

    /**
     * children
     */
    private Set<OrgVirtualTreeNode> children;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgVirtualTreeNode that = (OrgVirtualTreeNode) o;
        return Objects.equals(this.key, that.key) &&
                Objects.equals(this.pid, that.pid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, pid);
    }
}
