package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * 功能集
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class ResourcesetDto implements IOperator {

    /**
     * 功能集id
     */
    @JsonView(View.class)
    protected Long resourcesetId;

    /**
     * 应用id
     */
    @JsonView(View.class)
    protected Long appId;

    /**
     * 应用名称
     */
    @JsonView(View.class)
    protected String appName;

    /**
     * 资源码模块ID
     */
    @JsonView(View.class)
    protected Long resourceId;

    /**
     * 功能集Code
     */
    @JsonView(View.class)
    protected String resourcesetCode;

    /**
     * 功能集名称
     */
    @JsonView(View.class)
    protected String resourcesetName;

    /**
     * 功能集描述
     */
    @JsonView(View.class)
    protected String resourcesetDesc;

    /**
     * 启用状态  1:启用, 0:注销
     */
    @JsonView(View.class)
    protected Integer status;

    /**
     * 创建时间
     */
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    @JsonView({View.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({View.class})
    protected String createrName;

    /**
     * 更新人id
     */
    @JsonView({View.class})
    protected String updaterId;

    /**
     * 更新人名称
     */
    @JsonView({View.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 自定义功能集对应的角色ID
     */
    @JsonView(View.class)
    protected Long roleId;

    /**
     * 关联查出的服务包id
     */
    @JsonView(View.class)
    protected Long packageId;

    /**
     * 关联查出的服务包code
     */
    @JsonView(View.class)
    protected String packageCode;
    /**
     * 关联查出的角色id
     */
    @JsonView(View.class)
    protected Long relatedRoleId;
    /**
     * 关联查出的角色code
     */
    @JsonView(View.class)
    protected String relatedRoleCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourcesetDto that = (ResourcesetDto) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }
}
