package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.view.SysRole;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import java.util.*;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 权限角色
 *
 * @author geewit
 */
@SuppressWarnings("all")
@Schema(name = "权限角色Dto")
@FieldNameConstants
@Setter
@Getter
public class RoleDto extends TokenRole implements IOperator {

    /**
     * 角色描述
     */
    @JsonView({View.class, RedisView.class})
    protected String roleDesc;

    /**
     * 创建人id
     */
    @JsonView({View.class, RedisView.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({View.class, RedisView.class})
    protected String createrName;

    /**
     * 创建时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 更新人id
     */
    @JsonView({View.class, RedisView.class})
    protected String updaterId;

    /**
     * 更新人名称
     */
    @JsonView({View.class, RedisView.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 启用状态 1:启用, 0:注销
     */
    @JsonView({View.class, RedisView.class})
    protected Integer status;

    /**
     * 角色标签集合
     */
    @ArraySchema(schema = @Schema(implementation = Tag.class))
    @JsonView(RoleView.RoleInfo.class)
    protected Set<Tag> tags;

    /**
     * 租户集合
     */
    @JsonView(SysRole.class)
    protected Set<Long> tenantIds;

    /**
     * 功能集id集合
     */
    @JsonView(SysRole.class)
    protected Set<Long> resourcesetIds;

    /**
     * 功能集集合
     */
    @ArraySchema(schema = @Schema(implementation = ResourcesetDto.class))
    @JsonView(RoleView.RoleInfo.class)
    protected Set<ResourcesetDto> resourcesets;

    /**
     * 自定义功能集下资源码集合
     */
    @ArraySchema(schema = @Schema(implementation = ResourceDto.class))
    @JsonView(RoleView.RoleInfo.class)
    protected Set<ResourceDto> resources;

    /**
     * 角色关联的员工数量
     */
    @JsonView({View.class, RedisView.class})
    protected Long userCnt = 0L;

    /**
     * 默认角色/默认绑定人员
     */
    @JsonView(View.class)
    protected Boolean defaultBindUser;

    public void setRoleName(String roleName) {
        this.name = roleName;
    }

    public void setRoleCode(String roleCode) {
        this.code = roleCode;
    }

    @JsonView(View.class)
    public boolean isValid() {
        return this.status != null && this.status != 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleDto that = (RoleDto) o;
        if (this.id == null || this.id == 0) {
            return false;
        }
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code=" + code +
                ", name=" + name +
                ", tags=" + tags +
                '}';
    }
}
