package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 租户
 * @author geewit
 */
@SuppressWarnings("all")
@Schema(name = "租户Dto")
@FieldNameConstants
@Setter
@Getter
public class TenantDto implements IOperator {
    /**
     * 租户id
     */
    @JsonView({View.class, RedisView.class})
    protected Long tenantId;

    /**
     * 租户名称
     */
    @JsonView({View.class, RedisView.class})
    protected String tenantName;

    /**
     * 租户代码
     */
    @JsonView({View.class, RedisView.class})
    protected String tenantCode;

    /**
     * 租户描述
     */
    @JsonView({View.class, RedisView.class})
    protected String tenantDesc;

    /**
     * 入驻来源
     */
    @JsonView({View.class, RedisView.class})
    protected String settledOrigin;

    /**
     * 操作理由
     */
    @JsonView({View.class, RedisView.class})
    protected String operateReason;

    /**
     * 租户图标
     */
    @JsonView({View.class, RedisView.class})
    protected String tenantLogo;

    /**
     * 状态  1:用, 0:禁用
     */
    @JsonView({View.class, RedisView.class})
    protected Integer status;

    /**
     * 创建时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    @JsonView({RedisView.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({RedisView.class})
    protected String createrName;

    /**
     * 更新人id
     */
    @JsonView({RedisView.class})
    protected String updaterId;

    /**
     * 更新人名称
     */
    @JsonView({RedisView.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class, RedisView.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView({View.class, RedisView.class})
    protected Long companyCount;

    /**
     * 租户扩展
     */
    @ArraySchema(schema = @Schema(implementation = TenantExtensionDto.class))
    @JsonView(View.class)
    protected List<TenantExtensionDto> extensions;

    /**
     * 租户管理员
     */
    @ArraySchema(schema = @Schema(implementation = UserDto.class))
    @JsonView(View.class)
    private List<UserDto> admins;

    public List<UserDto> getAdmins() {
        return admins;
    }

    /**
     * 租户管理员
     * @return
     */
    @JsonView(View.class)
    public TenantManager getTenantManager() {
        if (CollectionUtils.isEmpty(this.admins)) {
            return null;
        }
        return this.admins.stream().filter(Objects::nonNull).map(admin -> {
            if (admin.getAccount() == null) {
                return null;
            }
            TenantManager tenantManager = TenantManager
                    .builder()
                    .userId(admin.getId())
                    .tenantId(admin.getTenantId())
                    .name(admin.getUserName())
                    .account(admin.getAccount().getUsername())
                    .emailAccount(admin.getAccount().getEmail())
                    .phoneAccount(admin.getAccount().getTelPhone())
                    .accountId(admin.getAccount().getAccountId())
                    .build();
            return tenantManager;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantDto)) {
            return false;
        }
        TenantDto that = (TenantDto) o;
        return Objects.equals(this.tenantId, that.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId);
    }
}
