package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.Objects;

/**
 * 租户扩展
 * @author geewit
 */
@FieldNameConstants
@Setter
@Getter
public class TenantExtensionDto extends ExtensionDto {
    /**
     * 租户id
     */
    @JsonView(View.class)
    protected Long tenantId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TenantExtensionDto) {
            TenantExtensionDto that = (TenantExtensionDto) o;
            return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(super.extensionKey, that.extensionKey);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId, super.extensionKey);
    }
}
