package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import lombok.*;
import lombok.experimental.FieldNameConstants;
import org.apache.commons.lang3.StringUtils;

/**
 * 租户管理员
 * @author duanhy
 */
@SuppressWarnings("all")
@FieldNameConstants
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
public class TenantManager {

    /**
     * 租户id
     */
    @JsonView({View.class})
    private Long tenantId;

    /**
     * 域账号
     */
    @JsonView({View.class})
    private String account;

    /**
     * 邮箱账号
     */
    @JsonView({View.class})
    private String emailAccount;

    /**
     * 手机账号
     */
    @JsonView({View.class})
    private String phoneAccount;

    /**
     * 姓名
     */
    @JsonView({View.class})
    private String name;

    /**
     * userId
     */
    @JsonView({View.class})
    private Long userId;

    /**
     * accountId
     */
    @JsonView({View.class})
    private Long accountId;

    @JsonIgnore
    public String getIdentifier() {
        if (StringUtils.isNotBlank(this.name)) {
            return this.name;
        }
        if (StringUtils.isNotBlank(account)) {
            return this.account;
        }
        if (StringUtils.isNotBlank(emailAccount)) {
            return this.emailAccount;
        }
        if (StringUtils.isNotBlank(phoneAccount)) {
            return this.phoneAccount;
        }
        return null;
    }
}