package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@SuppressWarnings("all")
@FieldNameConstants
@Setter
@Getter
public class TenantPolicyDto implements IOperator {
    /**
     * Password长度代码 @{value}
     */
    public final static String CREDENTIAL_LENGTH_NAME = "passwordLength";
    /**
     * Password Regex长度代码 @{value}
     */
    public final static String CREDENTIAL_REGEX_NAME = "passwordRegex";
    /**
     * Bind Auth @{value}
     */
    public final static String BIND_AUTH_NAME = "bindAuth";
    /**
     * change paasword.
     */
    public final static String CHANGE_PASSWD_NAME = "changePassword";

    /**
     * 创建公司是否需要审核, 0不需要审核，1需要
     */
    public final static String CREATE_COMPANY_AUDIT = "createCompanyAudit";

    /**
     * 加载用户资源码使用新逻辑, 0: 不使用新逻辑,  1: 使用新逻辑
     */
    public final static String LOAD_USER_RESOURCE_NEW = "loadUserResourceNew";

    protected Long id;
    /**
     * 租户id
     */
    protected Long tenantId;
    /**
     * 策略名称
     */
    protected String name;
    /**
     * 策略值
     */
    protected String policy;
    /**
     * 创建人id
     */
    protected String createrId;
    /**
     * 创建人名称
     */
    protected String createrName;
    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    /**
     * 更新人id
     */
    protected String updaterId;
    /**
     * 更新人名称
     */
    protected String updaterName;
    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 租户名称
     */
    protected String tenantName;

    /**
     * 租户代码
     */
    protected String tenantCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantPolicyDto)) {
            return false;
        }
        TenantPolicyDto that = (TenantPolicyDto) o;
        return Objects.equals(this.tenantId, that.tenantId) &&
                Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId, this.name);
    }
}
