package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 租户之间的关系
 * @author geewit
 */
@SuppressWarnings("all")
@FieldNameConstants
@Setter
@Getter
public class TenantRelationDto implements IOperator {

    protected Long id;

    /**
     * 上級租户id
     */
    @JsonView({View.class})
    protected Long parentTenantId;

    /**
     * 下級租户id
     */
    @JsonView({View.class})
    protected Long childTenantId;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 创建人id
     */
    protected String createrId;

    /**
     * 创建人名称
     */
    protected String createrName;

    /**
     * 更新人id
     */
    protected String updaterId;

    /**
     * 更新人名称
     */
    protected String updaterName;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

}
