package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 租户服务包
 * @author cpp
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class TenantServicePackageDto implements IOperator {

    /**
     * 租户服务包ID
     */
    @JsonView({View.class, View.Page.class})
    protected Long id;

    /**
     * 租户ID
     */
    @JsonView({View.class, View.Page.class})
    protected Long tenantId;

    /**
     * 产品服务包ID
     */
    @JsonView({View.Info.class})
    protected Long servicePackageId;

    /**
     * 状态  1:有效, 0:无效
     */
    @JsonView({View.class})
    protected Integer status;

    /**
     * 软删除状态  1:已删除, 0:未删除
     */
    @JsonView({View.class})
    protected Integer deleted;

    /**
     * 创建人ID
     */
    @JsonView({View.class})
    protected String createrId;

    /**
     * 创建人名称
     */
    @JsonView({View.class})
    protected String createrName;

    /**
     * 创建时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    /**
     * 更新人ID
     */
    @JsonView({View.class})
    protected String updaterId;

    /**
     * 更新人姓名
     */
    @JsonView({View.class})
    protected String updaterName;

    /**
     * 更新时间
     */
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    /**
     * 备注
     */
    @JsonView({View.class})
    protected String comments;

    /**
     * 租户名称
     */
    @JsonView({View.class})
    protected String tenantName;

    /**
     * 租户code
     */
    @JsonView({View.class})
    protected String tenantCode;

    /**
     * 应用名称
     */
    @JsonView({View.class})
    protected String appName;

    /**
     * 服务包Id集合
     */
    @JsonView({View.class})
    protected List<Long> servicePackageIds;

    /**
     * 服务包名称集合
     */
    @JsonView({View.class})
    protected List<String> servicePackageNames;

    /**
     * 服务包Code集合
     */
    @JsonView({View.class})
    protected List<String> servicePackageCodes;

    /**
     * 服务包总数
     */
    @JsonView({View.class})
    private Long total;

    public TenantServicePackageDto() {
    }

    public TenantServicePackageDto(Long id, Long tenantId, Long servicePackageId) {
        this.id = id;
        this.tenantId = tenantId;
        this.servicePackageId = servicePackageId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TenantServicePackageDto that = (TenantServicePackageDto) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(this.tenantId, that.tenantId) &&
                        Objects.equals(this.servicePackageId, that.servicePackageId);
            }
        } else {
            return Objects.equals(id, that.id);
        }
    }

    @Override
    public int hashCode() {
        if (id != null) {
            return Objects.hash(id);
        }
        return Objects.hash(tenantId, servicePackageId);
    }
}
