/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgUserDTO.java   2020-12-28 16-23-18
 * Author: Evan
 */
package com.xforceplus.domain.user;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

import java.util.Date;

/**
 * <p>
 * Title: OrgUserDTO
 * </p>
 * <p>
 * Description:OrgUserDTO
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-28 16-23-18
 * @since V1.0
 */
@FieldNameConstants
@Setter
@Getter
@ToString
public class OrgUserDTO {

    /**
     * 租户Id
     */

    private Long tenantId;
    /**
     * 组织ID
     */
    @JsonView(View.List.class)
    private Long orgId;
    /**
     * 组织ID
     */
    private String orgCode;
    /**
     * 当组织是公司类型的时，则该字段不为空
     */
    private Long companyId;
    /**
     * 用户ID
     */
    @JsonView(View.List.class)
    private Long userId;
    /**
     * 用户状态：
     */
    private Integer userStatus;
    /**
     * 用户-姓名
     */
    private String realName;
    /**
     * 用户代码
     */
    private String userCode;
    /**
     * 用户-员工号
     */
    private String userNumber;
    /**
     * 用户-手机号
     */
    private String userTelPhone;
    /**
     * 用户创建时间
     */
    private Date createdTime;
    /**
     * 账号ID
     */
    @JsonView(View.List.class)
    private Long accountId;
    /**
     * 账号-用户名
     */
    @JsonView(View.List.class)
    private String accountUserName;
    /**
     * 账号-Email
     */
    @JsonView(View.List.class)
    private String accountEmail;
    /**
     * 账号-手机号
     */
    @JsonView(View.List.class)
    private String accountTelPhone;

    /**
     * 用户-组织绑定时间
     */
    private Date boundTime;

    /**
     * 用户姓名
     */
    @JsonView(View.List.class)
    private String userName;

    @JsonView(View.List.class)
    private Integer relType;

    /**
     * @deprecated
     * @return 常量 0
     */
    public Integer getUserType() {
        return 0;
    }
}
