package com.xforceplus.enums;

/**
 * @author zhouxin, duanhy
 */
public interface FileTemplateEnum {

    enum Template {
        //角色租户功能集
        SYS_ROLE_TENANT_RESOURCESET("sys_role_rel.xlsx", "role.xlsx", "角色租户功能集"),
        //公司服务配置
        COMPANY_CONFIGURATION_TEMPLATE("company_configuration_template.xlsx", "company_configuration_template.xlsx", "公司服务配置"),
        //绑定账号到角色配置
        ACCOUNT_ROLE_TEMPLATE("account_role_template.xlsx", "account_role_template.xlsx", "绑定账号到角色配置"),
        //公司服务包
        COMPANY_SERVICE_TEMPLATE("company_service_template.xlsx", "company_service_template.xlsx", "公司服务包"),
        //公司导入模版
        COMPANY_EXPORT_TEMPLATE("company_export_template.xlsx", "company_export_template.xlsx", "公司导入模版"),
        //组织导入模版
        ORG_EXCEL_TEMPLATE("org_excel_template.xlsx", "org_excel_template.xlsx", "组织导入模版"),
        //用户导入模板
        USER_TEMPLATE("batch_import_user_template_V2.xlsx", "batch_import_user_template_V2.xlsx", "用户导入模板"),
        //公司批量修改(税号或名称)模板
        COMPANY_UPDATE_IMPORT_TEMPLATE("company_update_import_template.xlsx", "company_update_import_template.xlsx", "公司批量修改模板"),
        //角色账号授权批量导入模板
        ROLE_ACCOUNT_IMPORT_TEMPLATE("role_account_import_template.xlsx", "role_account_import_template.xlsx", "角色账号授权批量导入"),
        //业务组织导入模板
        ORG_VIRTUAL_IMPORT_TEMPLATE("org_virtual_import_template.xlsx", "org_virtual_import_template.xlsx", "业务组织批量导入"),
        //业务组织树导入模板
        ORG_VIRTUAL_NODE_IMPORT_TEMPLATE("org_virtual_node_import_template.xlsx", "org_virtual_node_import_template.xlsx", "业务组织树批量导入");

        private final String fileName;

        private final String targetName;

        private final String message;


        Template(String fileName, String targetName, String message) {
            this.fileName = fileName;
            this.targetName = targetName;
            this.message = message;
        }

        public String fileName() {
            return this.fileName;
        }

        public String targetName() {
            return this.targetName;
        }

        public String message() {
            return this.message;
        }


    }

    enum BatchImportTemplate {
        //公司服务配置批量导入模板
        BATCH_IMPORT_COMPANY_CONFIG_TEMPLATE("batch_import_company_config_template.xlsx", "batch_import_company_config_template.xlsx", "公司服务配置批量导入模板"),
        //公司服务包批量导入模板
        BATCH_IMPORT_COMPANY_PACKAGE_TEMPLATE("公司服务包导入.xlsx", "公司服务包导入.xlsx", "公司服务包批量导入模板"),
        //公司批量导入模板
        BATCH_IMPORT_COMPANY_TEMPLATE("运营管理_批量导入公司v1.xlsx", "运营管理_批量导入公司v1.xlsx", "公司批量导入模板"),
        //公司编号批量导入模板
        BATCH_IMPORT_COMPANY_NO_TEMPLATE("批量导入公司编号_v1.xlsx", "批量导入公司编号_v1.xlsx", "公司编号批量导入模板"),
        //组织批量导入模板
        BATCH_IMPORT_ORG_TEMPLATE("组织-公司批量导入_V3.3.xlsx", "组织-公司批量导入_V3.3.xlsx", "组织批量导入模板"),
        //人员批量导入模板
        BATCH_IMPORT_USER_TEMPLATE("批量导入用户_v2.3.xlsx", "批量导入用户_v2.3.xlsx", "人员批量导入模板"),
        //角色批量导入模板
        BATCH_IMPORT_ROLE_TEMPLATE("batch_import_role_template_V2.xlsx", "batch_import_role_template_V2.xlsx", "角色批量导入模板"),
        //资源批量导入模板
        BATCH_IMPORT_RESOURCE_TEMPLATE("batch_resource_import_template.xlsx", "batch_resource_import_template.xlsx", "资源码批量导入模板"),
        //资源批量导入模板
        BATCH_IMPORT_RESOURCE_SET_TEMPLATE("batch_resource_set_import_template.xlsx", "batch_resource_set_import_template.xlsx", "功能集批量导入模板"),
        //产品服务包
        BATCH_IMPORT_SERVICE_PACKAGE_TEMPLATE("产品服务包导入v2.xlsx", "产品服务包导入v2.xlsx", "产品服务包批量导入模板"),
        //业务组织批量关联行政组织导入模板
        BATCH_IMPORT_ORG_VIRTUAL_ORG_STURCT_TEMPLATE("batch_org_virtual_org_struct_import_template.xlsx", "batch_org_virtual_org_struct_import_template.xlsx", "业务组织批量关联行政组织导入模板"),
        //公司扩展字段导入
        BATCH_IMPORT_ORG_EXTENSION_TEMPLATE("batch_import_org_extension.xlsx", "batch_import_org_extension.xlsx", "公司扩展字段批量导入模板");

        private final String fileName;

        private final String targetName;

        private final String message;


        BatchImportTemplate(String fileName, String targetName, String message) {
            this.fileName = fileName;
            this.targetName = targetName;
            this.message = message;
        }

        public String fileName() {
            return this.fileName;
        }

        public String targetName() {
            return this.targetName;
        }

        public String message() {
            return this.message;
        }
    }
}
