package com.xforceplus.enums;

import lombok.Getter;

@Getter
public enum ServicePackageTypeEnum implements BaseEnum<String>{
    STANDARD(1, "标准"),
    CUSTOM(2, "二开");

    private final int type;

    private final String typeDesc;

    ServicePackageTypeEnum(int type, String typeDesc) {
        this.type = type;
        this.typeDesc = typeDesc;
    }

    public int getType() {
        return type;
    }

    public String getTypeDesc() {
        return typeDesc;
    }


    @Override
    public String getValue() {
        return getTypeDesc();
    }
}