package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * 合并状态
 */
public enum CloudShellMergeState {
    UNKNOWN(0), // 未知
    CREATED(1), // 需要创建
    CHANGED(2), // 有修改
    FIXED(3), // 固定的.
    BINDING(4), //需要绑定关系的
    NO_CHANGE(5), // 没有变化.
    CONFLICT(6), // 冲突.
    EXCLUDE(7); // 主动排除.

    private final int value;

    CloudShellMergeState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static CloudShellMergeState valueOf(int value) {
        return Stream.of(CloudShellMergeState.values())
                .filter(v -> v.value() == value)
                .findFirst()
                .orElse(UNKNOWN);
    }
}