package com.xforceplus.enums.cloudshell;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.stream.Stream;

/**
 * @author dongbin
 * @version 0.1 2023/5/24 11:36
 * @since 1.8
 */
public enum DesignSchemeAdjustOperation {

    /**
     * 表示错误.
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    UNKNOWN(0),

    /**
     * 排除.
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    EXCLUDE(1),

    /**
     * 包含. 也有取消,或恢复原有状态的行为
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    INCLUDE(2);

    private final int value;

    DesignSchemeAdjustOperation(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static DesignSchemeAdjustOperation valueOf(int value) {
        return Stream.of(DesignSchemeAdjustOperation.values())
                .filter(v -> v.value() == value)
                .findFirst()
                .orElse(UNKNOWN);
    }

    /**
     * 通过名称得到对应实例.
     */
    public static DesignSchemeAdjustOperation fromName(String name) {
        return Stream.of(DesignSchemeAdjustOperation.values())
                .filter(v -> v.name().equals(name) || v.name().equalsIgnoreCase(name))
                .findFirst()
                .orElse(UNKNOWN);
    }

}
