package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * 设计类型.
 *
 * @author dongbin
 * @version 0.1 2023/5/9 17:26
 * @since 1.8
 */
public enum DesignSchemeType {
    UNKNOWN(0, "unknown"),
    FUNCTION_SCHEME(1, "function"),
    ROLE_SCHEME(2, "role"),
    USER_ACCOUNT_SCHEME(3, "useraccount"),
    ORG_SCHEME(4, "org"),;

    private final int value;
    private final String name;

    DesignSchemeType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int value() {
        return this.value;
    }

    public String valueName() {
        return this.name;
    }

    public static DesignSchemeType valueOf(int value) {
        return Stream.of(DesignSchemeType.values())
                .filter(v -> v.value() == value)
                .findFirst()
                .orElse(UNKNOWN);
    }

    /**
     * 通过名称得到对应实例.
     */
    public static DesignSchemeType fromValueName(String valueName) {
        return Stream.of(DesignSchemeType.values())
                .filter(v -> v.valueName().equals(valueName) || v.valueName().equalsIgnoreCase(valueName))
                .findFirst()
                .orElse(UNKNOWN);
    }
}
