package com.xforceplus.enums.cloudshell;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

/**
 * 功能类型.
 * @author geewit
 */
public enum ParticipantType {
    TENANT("租户", "T"),
    SERVICE_PACKAGE("服务包", "SP"),
    ROLE("角色", "R"),
    RESOURCE_SET("功能集", "RS"),
    RESOURCE_CODE("资源码", "RC"),
    ORG("组织", "O"),
    COMPANY("公司", "C"),
    ORG_TYPE("自定义组织类型", "OT");

    private final String name;

    private final String abbr;

    ParticipantType(String name, String abbr) {
        this.name = name;
        this.abbr = abbr;
    }

    public String getName() {
        return this.name;
    }

    @JsonValue
    public String abbr() {
        return this.abbr;
    }

    public String generateId(Long id) {
        return this.abbr() + "-" + id;
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static ParticipantType fromAbbr(String value) {
        return Stream.of(ParticipantType.values())
            .filter(type -> type.abbr().equalsIgnoreCase(value)
                    || type.name().equalsIgnoreCase(value))
            .findFirst()
            .orElseThrow(() -> new IllegalArgumentException(
                "No enum constant " + ParticipantType.class.getCanonicalName() + "." + value));
    }
}