package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * TaskOperation执行失败的原因.
 *
 * @author dongbin
 * @version 0.1 2023/6/30 11:57
 * @since 1.8
 */
public enum TaskOperationFailureCause {

    /**
     * 没有原因.
     */
    UNKNOWN(0),

    /**
     * 重复.
     */
    DUPLICATE(1),

    /**
     * 数据无效.
     */
    DATA_INVALID(2);

    private final int value;

    TaskOperationFailureCause(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static TaskOperationFailureCause valueOf(int value) {
        return Stream.of(TaskOperationFailureCause.values())
            .filter(v -> v.value() == value)
            .findFirst()
            .orElse(UNKNOWN);
    }

}
