package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * 表示TaskOperation的执行状态.
 *
 * @author dongbin
 * @version 0.1 2023/6/30 11:55
 * @since 1.8
 */
public enum TaskOperationRunStatus {

    /**
     * 未知,应该表示一个错误.
     */
    UNKNOWN(0),

    /**
     * 成功.
     */
    SUCCESS(1),

    /**
     * 失败.
     */
    FAILURE(2);

    private final int value;

    TaskOperationRunStatus(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static TaskOperationRunStatus valueOf(int value) {
        return Stream.of(TaskOperationRunStatus.values())
            .filter(v -> v.value() == value)
            .findFirst()
            .orElse(UNKNOWN);
    }
}
